/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CSETTINGS_H
#define CSETTINGS_H

#include "../global.h"

struct set_TTY
{
    QString Port;
    int MaxPorts;
    int PortID;
    QString Ports[10];
};

struct set_GUI
{
    bool   isMax;
    QSize  Size;
    QPoint Point;
    QBitArray TabViews;
    QBitArray ToolViews;
    bool Term_Info;
    bool Term_Data;
    bool Term_Always;
    bool Term_Send;
};

struct set_Map
{
    bool GotoPosition;
    bool ShowTrack;
    double LastLatitude;
    double LastLongitude;
};

struct set_Data
{
    int Plotter_Count;
    int Debug_Fast;
    int Debug_Slow;
    int Debug_Off;
    int Navi_Fast;
    int Navi_Slow;
    int Navi_Off;
};

struct set_DIR
{
    QString Logging;
    QString Parameter;
    QString Cache;
    QString AVRDUDE;
};

struct set_Server
{
    QString Port;
    bool StartServer;
    bool ToGround;
    QString QMKS_Login;
    QString QMKS_Password;
    QString QMKS_Host;
    QString QMKS_Port;
};


struct set_Analog
{
    QString   Version;
    QString   Label[MaxAnalog];
    QBitArray PlotView;
    QBitArray LogView;
};

class cSettings
{
public:
    cSettings();
    ~cSettings();

    int Settings_ID;

    set_GUI GUI;
    set_DIR DIR;
    set_TTY TTY;
    set_Analog Analog1;
    set_Data Data;
    set_Server Server;
    set_Map Map;

    void read_Settings();
    void read_SettingsID();
    void write_Settings();
    void write_Settings_Analog(int ID = 0);
    void read_Settings_Analog(int ID = 0);
    void write_Settings_AnalogLabels(int ID = 0);
    void read_Settings_AnalogLabels(int ID = 0);
};

#endif
